function trial_sample = vb_info_get_trial_sample(info, active_swt)
% <getter> return trial sample list from MEGinfo or EEGinfo
% [usage]
%   trial_sample = vb_info_get_trial_sample(info, active_swt)
% [input]
%           info : <required> <<struct>> MEGinfo or EEGinfo
%     active_swt : <optional> <<boolean>> return switch [false]
%                :   true) return only active_trials
%                :  false) return all the trials
% [output]
%   trial_sample : sample list of trial [Ntrial x Nsample]
% [note]
%   @see vb_info_get_trial_list
% [hitory]
%   2008-04-15 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[info, active_swt] = inner_check_arguments(info, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
trial_sample = [];
trial_list = vb_info_get_trial_list(info, [], active_swt);

if isempty(trial_list)
  return;
end

n_trial = length(trial_list);
n_sample = length(info.Trial(1).sample);
trial_sample = zeros(n_trial,n_sample);
for i_trial = n_trial
  trial_sample(i_trial,:) = info.Trial(trial_list(i_trial)).sample;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, active_swt] = inner_check_arguments(info, active_swt)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
