function n_trial = vb_info_get_trial_number(info, active_swt)
% return number of trial from info (MEGinfo or EEGinfo) struct
% [usage]
%   n_trial = vb_info_get_trial_number(info, active_swt)
% [input]
%         info : <required> <<struct>> MEGinfo or EEGinfo for now
%   active_swt : <optional> <<boolean>> [false]
%              :  target trials are whether only active or all
%              :    true) active trial
%              :   false) all the trial
% [output]
%      n_trial : number of trial
% [note]
%   @see vb_info_get_trial_list
%   this function is vb_info_get_Nrepeat + active_swt
% [history]
%   2008-04-15 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[info, active_swt] = inner_check_arguments(info, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
trial_list = vb_info_get_trial_list(info, [], active_swt);
n_trial = length(trial_list);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, active_swt] = inner_check_arguments(info, active_swt)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
