function  n_sample = vb_info_get_sample_number(info)
% return Nsample field from MEGinfo or EEGinfo
% [usage]
%   n_sample = vb_info_get_sample_number(info)
% [input]
%   info : <required> MEGinfo or EEGinfo
% [output]
%   n_sample : number of sample (.Nsample field)
% [note]
%   Nsample field is one of the required fields
% [history]
%   2009-07-28 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
[info] = inner_check_arguments(info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
n_sample = info.Nsample;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info] = inner_check_arguments(info)
func_ = mfilename;
if isempty(info)
  error('(%s) info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
