function [active_channel] = vb_info_get_active_channel(info, ch_type)
% <<getter>> return active channel field from MEGinfo or EEGinfo
% [usage]
%   [active_channel] = vb_info_get_active_channel(info, ch_type)
% [input]
%             info : <required> <<struct>> MEGinfo or EEGinfo
%          ch_type : <optional> <<integer>> channel type [1]
%                  :  1) MEG or EEG channels
%                  :  2) only extra channels
%                  :  3) all channels
% [output]
%   active_channel : active channel field as it is
% [note]
%
% [history]
%   2008-04-14 (Sako) initial version
%   2008-06-05 (Sako) added ch_type
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('ch_type', 'var'), ch_type = []; end
[info, ch_type] = inner_check_arguments(info, ch_type);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if ~isfield(info, 'ActiveChannel')
  active_channel = [];
  return;
end

switch ch_type
  case 1
    % MEG or EEG channels
    active_channel = info.ActiveChannel;
    return;

  case 2
    % only extra channels
    active_channel = info.ExtraChannelInfo.Channel_active;
    return;
    
  case 3
    % all channels
    active_channel = [info.ActiveChannel;info.ExtraChannelInfo.Channel_active];
    return;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, ch_type] = inner_check_arguments(info, ch_type)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end

if isempty(ch_type)
  ch_type = 1;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
