function Nch = vb_info_get_Nchannel(info)
% <<getter>> return Nchannel field of MEGinfo or EEGinfo
% [usage]
%   Nch = vb_info_get_Nchannel(info)
% [input]
%   info : <required> <<struct>> MEGinfo or EEGinfo
% [output]
%    Nch : value of Nchannel field
% [note]
%   with no intelligent action
%   *info struct must have "Nchannel" field if necessary
% [history]
%   2008-04-14 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
[info] = inner_check_arguments(info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
Nch = info.Nchannel;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info] = inner_check_arguments(info)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end

if ~isfield(info, 'Nchannel')
  info.Nchannel = 0;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
