function	ix = vb_trigger_onset_pre(y,y0,tpre,ymax,twin)
% Find onset time that signal exceed the threshold value 'y0'
%    vb_trigger_onset_pre(y,y0,tpre)
%    vb_trigger_onset_pre(y,y0,tpre,ymax,twin)
% --- main input
% y  : analog signal
% y0 : threshold value
% --- condition for event rejection
% time to previous event shoud be larger than 'tpre'
% 'y' value shoud be larger than 'ymax' within 'twin' period, if ymax~=[]
% --- Output
% ix : extracted onset time index
%      
% 2009-6-16 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% find event start (signal exceed the threshold)
ix = vb_trigger_start(y,y0);

if isempty(ix), return; end;

N  = length(ix);
%  avoid dimension swap for exceptional case
y  = y(:);

if nargin == 5 && ~isempty(ymax) && twin > 0
	twin = round(twin);
	t  = 1:twin;
	ii = repmat(ix(:)',twin,1) + repmat(t(:),1,N);
	ii = min(ii, length(y));
	
	yy = max(y(ii), [], 1);
	
	jj = find(yy >= ymax);
	
	ix = ix(jj);
end

% time to previous event shoud be larger than tpre
dx = [tpre diff(ix)];
jj = find(dx >= tpre);
ix = ix(jj) ;

