function	ix = vb_trigger_onset_event(y,y0,ymax,twin,Nrate)
% Find onset time that signal exceed the threshold value 'y0'
%    ix = vb_trigger_onset_event(y,y0,ymax,twin,Nrate)
% --- main input
% y  : analog signal
% y0 : threshold value for 'y'
% ymax : max value threshold within 'twin' period
% twin : period length
% Nrate: y should be larger than ymax for (twin*Nrate) samples
% --- condition for onset 
% if 'twin' is not empty,
% 'y' shoud exceed 'ymax' for (twin*Nrate) samples within twin period
% --- Output
% ix : extracted onset time index
%      
% 2011-12-16 Masa-aki Sato 
% 2012-1-8  Masa-aki Sato 
%   check exceptional cases
%   condition is changed
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% find event start (at which signal exceed the threshold)
ix = vb_trigger_start(y,y0);

if isempty(ix), return; end;
if isempty(twin), return; end;
if isempty(ymax), ymax = y0; end;
if nargin < 5 || isempty(Nrate), Nrate = 0.8; end;

N  = length(ix);
T  = length(y);

% time index for 'twin' period
twin = round(twin);
tt = 1:twin;

% # of samples to exceed 'ymax' within 'twin' period
Ny = zeros(N,1);

for n=1:N
	t = min(ix(n) + tt,T);
	Ny(n) = sum(y(t) >= ymax);
end

% 'y' shoud exceed 'ymax' for (twin*Nrate) samples within twin period
jj = find(Ny >= Nrate*twin);

ix = ix(jj);

%ix = vb_onset_check(ix,twin);

