function	ix = vb_multi_bit_end(y,status,t_stay)
% Find time points that signal differ from the given multi channel bit pattern
%     ix = vb_bit_ptn_end(y,status)
%     ix = vb_bit_ptn_end(y,status,t_stay)
% y(n,t) : event signal for n-th ch at time 't' [Nch x T]
% status : multi channel bit pattern [Nch x 1]
% t_stay : minimum length to stay the specified value [default = 10]
%          'y' should be stay at the value 'status' for more than t_stay
%          Then, 'y' changes to other value from 'status' 
% 
% ix : index corresponding to the end point 
%      'y' changes to other value from 'status' 
%      
% 2012-1-4 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 3, t_stay = 10; end;

[N,T] = size(y);

flg = ones(1,T-t_stay);
tt  = 1:T-t_stay;

% 'y' is not 'status' value afterward
for n=1:N
	flg = flg .* (y(n,tt + t_stay) == status(n));
end

flg = (flg ~= 1);

% 'y' should be stay at the value 'status' for more than t_stay
for n=1:N
	for t=0:t_stay-1
		flg = flg .* (y(n,tt + t) == status(n));
	end
end

ix = find(flg == 1);
ix = ix + t_stay - 1;

return
