function [result] = vb_get_status_integer(status,bit_ptn,bit_max)
% get status bit pattern from tnteger status signal
% [usage]
%   [result] = vb_get_status_integer(status,bit_ptn,bit_max)
% [input]
%   status  : integer status signal [ 1 x n_sample ]
%   bit_ptn : bit number list to get specified bit data from status signal
%           = [1:8] : get 1 to 8 bit from status
%   bit_max : bit length of original status signal before converted to integer
%           = [24] for Biosemi 
% [output]
%        result : integer value converted from status [1 x n_sample]
%   2009-6-25 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
result=[];
[M, T] = size(status);
if T==1 && M > 1, status = status'; T = M; M = 1; end;

if M > 1, error('status should be 1 x T'); end;
if nargin < 2, bit_ptn = 1:8; end;
if nargin < 3, bit_max = 24; end;

status = double(status);

% convert negative integer to positive integer
ix = find( status < 0 );
status(ix) = status(ix) + 2^bit_max;

bit_len = length(bit_ptn);

result = zeros(1, T);

for i_bit = 1:bit_len
	% get specified bit value
	i_val = 2^bit_ptn(i_bit);
 	result = bitand(status, i_val) + result;
end

%result = zeros(bit_len, T);
%
%for i_bit = 1:bit_len
%	i_val = 2^bit_ptn(i_bit);
% 	result(i_bit,:) = bitand(status, i_val)/i_val;
%end

% BITAND ӥåñ̤
%  C = BITAND(A,B) ϡ2Ĥΰ A  B Υӥåñ̤ѤϤޤ
%  A  B ϡʤǤʤФʤޤ
 
% BITGET ӥåȤμФ
%  C = BITGET(A,BIT) 
%  A ΰ BIT ˤӥåͤϤޤ
%  A ϡʤǡ
%  BIT  1  A ʤΥ饹Υӥåȿ
%  (UINT32Ǥ32)δ֤ͤǤʤФʤޤ
% 
return;
%
% --- END OF MAIN PROCEDURE --- %
