function	[ix ,zd, z, ix_y, yd, ix_z, ix_s] = vb_get_emg_onset(y,parm)
% Find EMG onset time using smoothed EMG signal
%    [ix ,zd, z] = vb_get_emg_onset(y, parm)
%    [ix ,zd, z, ix_y, yd, ix_z, ix_s] = vb_get_emg_onset(y, parm)
% --- Input
% y             : EMG signal
% parm  : parameter structure
% parm.fsamp    : sampling frequency [Hz]
% --- Optional parameter for EMG onset
% parm.t_event  : minimum distance from previous onset event [500 ms]
% --- Usually following parameters need not be changed
% parm.t_smooth : moving average window length                 [10 ms]
% parm.t_period : minimum period that Smoothed EMG > threshold [50 ms]
% parm.p_val : P-value corresponding to the threshold for [smooth(EMG)] 
%	         =  [0.001] 
% --- Condition for EMG onset
% 1. Smoothed EMG (yave) should exceed 'z0' more than 't_period' length
% 2. Distance from previous onset should be larger than 't_event'
%
% --- Output
% ix   : extracted onset time index
% zd   : smoothed EMG threshold value
% z    : smoothed EMG by moving average
% ix_y : abs(EMG) onset time index
% yd   : threshold for abs(y)     
% ix_z : smoothed EMG onset     
% ix_s : start & end of slope estimation region at jx
%
% 2009-09-05 Masa-aki Sato
% 2012-2-18  Masa-aki Sato 
%   Use TKE operator EMG filter
% 2012-2-22  Masa-aki Sato 
%   threshold determination is changed
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[yd, zd, z] = vb_get_emg_threshold(y, parm);

if isempty(parm.status_level)
	zd = yd;
else
	zd = yd * parm.status_level;
end

[ix ,ix_y, ix_z, ix_s] = vb_get_emg_onset_time(y , z ,yd, zd, parm);

%[ix] = vb_emg_spectral_check(y,ix,parm);


return
