function	vb_extract_trial_cond(fname1,fname2,fout)
% Extract trials of file1 which are also included in trials of file2
% : Intersection of trials in file1 and file2 
% --- Usage
%    vb_extract_trial_cond(fname1,fname2,fout)
% --- Input
%  fname1 : file name of examined trial
%  fname2 : file name of condition trial
%  fout   : output file name of extracted trial
% --- Save variables
% status : status signal
% status_val(m) = status value for m-th condition (m=1:Ncomdition)
% trig(n)       : Onset time index for n-th trial 
% cond_id(n)    : Condition ID for n-th trial 
% ix_trial(:,n) : Time index for n-th trial   [Tperiod x Ntrial]
%                 Tperiod : # of time sample in one trial
%                 Ntrial  : # of trials
% parm : parameter setting
%  parm.fsamp : Sample Frequency [Hz]
%  parm.Pretrigger_ms : Pretrigger period   [msec]
%  parm.Posttrigger_ms: Posttrigger period  [msec]
%
% 2009-6-14  Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% load condition trial 
load(fname2,'ix_trial','trig','status','status_val','cond_id','parm');

fs = parm.fsamp;
ix_cond = ix_trial;
Tmax = size(status,2);

% load main trial 
load(fname1,'ix_trial','trig','cond_id','status','status_val','parm');

if fs ~= parm.fsamp, error('Sample frequency mismatch'); end;
if Tmax ~= size(status,2), error('Sample length mismatch'); end

[T, Ntr] = size(ix_trial);

% Set condition flag
flag = zeros(Tmax,1);

for n=1:size(ix_cond,2)
	flag(ix_cond(:,n)) = 1;
end

% Extract trials included in 'ix_cond'
nn = 0;
nlist = [];
ix_list = [];

for n=1:Ntr
	% old n-th trial
	jx = ix_trial(:,n);
	
	% extract time points included in 'ix_cond'
	jj = find( flag(jx) > 0 );
	Nj = length(jj);
	
	if Nj > 0,
		nn = nn + 1;
		nlist = [nlist, n];
		ix_list = [ix_list; jj(1) jj(end)];
	end
end

if nn == 0,
	ix_trial = [];
	trig = [];
	cond_id = [];
	return;
end

% intersection of trials with 'ix_cond'
j1 = max(ix_list(:,1));
j2 = min(ix_list(:,2));

if j1 > j2,
	ix_trial = [];
	trig = [];
	cond_id = [];
	return;
end

fprintf('# of extracted trials = %d\n',length(nlist));

ix_trial = ix_trial( j1:j2 , nlist) ;
trig     = trig(nlist)     ;
cond_id  = cond_id(nlist)  ;

Pretrigger = trig(1) - ix_trial(1,1);
Posttrigger= ix_trial(1,end) - trig(1);

parm.Pretrigger_ms = Pretrigger *(1000/fs);
parm.Posttrigger_ms= Posttrigger*(1000/fs);

vb_fsave(fout,'ix_trial','trig','status','status_val','cond_id','parm');
