function	ix = vb_event_end(y,status,t_stay)
% Find time points that signal differ from the specified value 'status'
%   ix = vb_event_end(y,status)
%   ix = vb_event_end(y,status,t_stay)
% y : event signal
% status : status value
% t_stay : minimum length to stay the specified value [default = 10]
%          'y' should be stay at the value 'status' for more than t_stay
%          Then, 'y' changes to other value from 'status' 
% ix : index corresponding to the end point 
%      'y' changes from 'status' to other value
%      
% 2009-6-11 Masa-aki Sato
% 2012-1-8  Masa-aki Sato Bug fix
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 3, t_stay = 10; end;

T = length(y);

% take bitwise AND to ignore irrelevant bit
y = bitand(y,status);

flg = ones(1,T-t_stay);
tt  = 1:T-t_stay;

% 'y' is not 'status' value afterward
flg = flg .* (y(tt + t_stay) ~= status);

% 'y' should be stay at the value 'status' for more than t_stay
for t=0:t_stay-1
	flg = flg .* (y(tt + t) == status);
end

ix = find(flg == 1);
ix = ix + t_stay - 1;

return

% Status value 'y' should be stay at the value ~='status' for more than t_stay
ix = find( y(2:T-t_stay) ~= status ...
         & y(2+t_stay:T) ~= status ...
         & y(1:T-1-t_stay) == status);

%ix = find( y(2:T) ~= status & y(1:T-1) == status);
