function	[trig, i_emg, sp, f] = vb_emg_spectral_check(y,trig,parm)
% Check EMG frequency spectrum
% If power of EMG frequency range (above 10 Hz) is 
% less than lower frequency power, it is rejected
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

T1 = 50;  % Pretrigger   100 ms 
T2 = 200; % Posttrigger  200 ms

Fhigh = 100; % upper frequency [Hz]
Flow  = 10;  % lower threshold frequency [Hz]

% Threshold value for low/high ratio
if isfield(parm,'emg_low_ratio') && ~isempty(parm.emg_low_ratio)
	R0 = parm.emg_low_ratio;
else
	R0 = 1;
end

N  = length(trig);
T0 = length(y);

fs = parm.fsamp;
tw = ceil( [T1 T2]* fs/1000);

% Time index for one trial
t  = [-tw(1):tw(2)-1];
T  = length(t);

% Time index for all trials extracted from 'trig'
t_trial = repmat(t(:),[1 N]) + repmat(round(trig(:))',[T 1]);
t_trial = max(t_trial,1);
t_trial = min(t_trial,T0);

% signal for all trials
xdata = y(t_trial);

% Frequency list for FFT
fd = fs/T;
f  = 0:fd:(fs/2);

% Window function
xx  = vb_repmultiply(xdata ,hanning(T));

% Frequency spectrum
sp = abs(fft(xx)).^2;

% remove hifh frequency than 'Fhigh'
jx = find( f <= Fhigh);
f  = f(jx);
sp = sp(jx,:);

% Lower frequency component than 'Flow'
lx = find( f <= Flow );

% ratio of low/high component
rs = sum(sp(lx,:),1)./sum(sp((lx(end)+1):end,:),1);

i_emg = find( rs <  R0); % index for correct EMG

trig = trig(i_emg);

i_rej = find( rs >= R0); % index for rejection 

if ~isempty(i_rej)
    figure;
	subplot 211
	plot(xdata(:,i_rej))
	title('Rejected EMG')
	xlabel('Time')
	ylabel('EMG')
	
	subplot 212
	plot(f,sp(:,i_rej))
	title('Rejected EMG spectrum')
	xlabel('Frequency [Hz]')
	ylabel('Spectral power')
end
