function [gain] = vb_calibinfo_get_sensor_gain(calib_info)
% return sensor gain from calib_info
%
% [usage]
%   [gain] = vb_calibinfo_get_sensor_gain(calib_info)
%
% [input]
%   calib_info : <required> <<struct>> calibration information
%              :  temporary struct for pre-process
%              :   .sensitivity <<struct array>> [1 x n_ch]
%              :     .offset
%              :     .gain
%              :   .fll <struct array>> [1 x n_fll]
%              :     .gain
%              :   .ad
%              :     .bit
%              :     .analog_range
%              :
%              :   .sensor_label {n_ch x 1}
%
% [output]
%         gain : sensor gain
%
% [note]
% 
% [history]
%   2007-06-28 (Sako) initial version
%   2011-06-28 (Sako) modified to use the new YOKOGAWA library
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('calib_info', 'var'), calib_info = []; end
[calib_info] = inner_check_arguments(calib_info);


% --- MAIN PROCEDURE --------------------------------------------------------- %
%
gain = [calib_info.sensitivity(:).gain]';
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [calib_info] = inner_check_arguments(calib_info)
func_ = mfilename;
if isempty(calib_info)
  error('(%s) calib_info is a required parameter', func_);
end

if ~isfield(calib_info, 'sensitivity')
  error('(%s) sensitivity is a required field', func_);
end

if ~isfield(calib_info.sensitivity, 'gain')
  error('(%s) sensitivity.gain is a required field', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
