function vb_plot_yokogawa_dipole_to_analyze(analyzefile,yokogawa_dipolefile)
% plot dipole data( estimated by MEGLaboratory ) to analyze file
%
% vb_plot_yokogawa_dipole_to_analyze(analyzefile,yokogawa_dipolefile)
%
% --- Input
% analyzefile : String   analyze image file name (*.hdr)
% yokogawa_dipolefile : String yokogawa dipole position file name (*.txt)
% --- Output
% figure : plot dipole point on the analyze image 
%
% written by M Osako  2006-06-14
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%% transform analyze coord (left-handed) to right-handed coord
[B, Vdim, Vsize] = vb_load_analyze_to_right(analyzefile);

%% read dipole position ( Ndipole x 3 )
dipole_position = textread(yokogawa_dipolefile);

%% transform yokogawa MRI coord to spm right-handed coord 
dipole_spmright = vb_yokogawa_mri_to_spm_right(dipole_position);

%% transform spm right-handed coord to analyze right-handed coord
dipole_ana = vb_spm_right_to_analyze_right(dipole_spmright,Vdim,Vsize);

%%plot act point on the analyze image
vb_plot_slice( B , dipole_ana , round(dipole_ana(:,3)) );
