function [MEGinfo] = vb_meginfo_set_pre_trigger(MEGinfo, pretrigger)
% set pretrigger to current MEGinfo struct
% [usage]
%   [MEGinfo] = vb_meginfo_set_pre_trigger(MEGinfo, pretrigger)
% [input]
%      MEGinfo : <required> <<struct>> MEG information
%   pretrigger : <optional> value of pre-trigger ([])
% [output]
%      MEGinfo : <<struct>> updated MEGinfo
% [note]
%   
% [hisotory]
%   2007-06-29 (Sako) initial version
%   2008-01-29 (Sako) renewed due to new specification
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


% --- CHECK ARGUMENTS --- %
if ~exist('MEGinfo', 'var'), MEGinfo = []; end
if ~exist('pretrigger', 'var'), pretrigger = []; end
[MEGinfo, pretrigger] = inner_check_arguments(MEGinfo, pretrigger);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% MEGinfo.Pretriger = pretrigger;
MEGinfo.Pretrigger = pretrigger;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [MEGinfo, pretrigger] = inner_check_arguments(MEGinfo, pretrigger)

func_ = mfilename;
if isempty(MEGinfo)
  error('(%s)MEGinfo is a required parameter', func_);
end

return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
