function [meg_info] = vb_meginfo_set_extra_ch_gain(meg_info, gain)
% <setter> set gain of extra channel to the appropriate field of MEGinfo
% [usage]
%   [meg_info] = vb_meginfo_set_extra_ch_gain(meg_info, gain)
% [input]
%   meg_info : <optional> <<struct>> MEGinfo []
%       gain : <optional> []
% [output]
%   meg_info : <<struct>> updated MEGinfo
% [note]
%   if meg_info is empty, this program creates new meg_info
% [history]
%   2008-02-08 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
if ~exist('gain', 'var'), gain = []; end
[meg_info, gain] = inner_check_arguments(meg_info, gain);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meg_info.ExtraChannelInfo.gain = gain;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [meg_info, gain] = inner_check_arguments(meg_info, gain)

if isempty(meg_info)
  meg_info.ExtraChannelInfo = [];
end

if isempty(gain)
  % require no action
end
return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
