function [prec] = vb_meginfo_get_precision(meginfo)
% return precision of binary data
% [usage]
%   [prec] = vb_meginfo_get_precision(meginfo)
% [input]
%   meginfo : <required> <<struct>> MEG information
% [output]
%      prec : precision used by fread or fwrite
% [note]
%   precision is used by fread or fwrite
%   if meginfo does not have saveman field, return empty string ('')
%   @see vb_saveman_get_precision()
% [history]
%   2007-06-25 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
[meginfo] = inner_check_arguments(meginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
prec = meginfo.saveman.precision;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo] = inner_check_arguments(meginfo)

func_ = 'vb_meginfo_get_precision';

if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if ~isfield(meginfo, 'saveman') || ~isfield(meginfo.saveman, 'precision')
  meginfo.saveman.precision = '';
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%--- END OF FILE ---%
