function [posttrigger] = vb_meginfo_get_post_trigger(MEGinfo)
% return post-trigger from current MEGinfo struct
% [usage]
%   [posttrigger] = vb_meginfo_get_post_trigger(MEGinfo)
% [input]
%      MEGinfo : <required> <<struct>> MEG information
% [output]
%   posttrigger : post-trigger value of current MEGinfo
% [note]
%   Posttrigger field is not regularly defined for MEGinfo
% [hisotory]
%   2007-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('MEGinfo', 'var'), MEGinfo = []; end
[MEGinfo] = inner_check_arguments(MEGinfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
posttrigger = MEGinfo.Posttrigger;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [MEGinfo] = inner_check_arguments(MEGinfo)

func_ = mfilename;
if isempty(MEGinfo)
  error('(%s)MEGinfo is a required parameter', func_);
end

if ~isfield(MEGinfo, 'Posttrigger')
  MEGinfo.Posttrigger = [];
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
