function next_acqtype = vb_meginfo_get_next_acq_type(meginfo, event, loadspec)
% [usage]
%   next_acqtype = vb_meginfo_get_next_acq_type(meginfo, event, loadspec)
% [input]
%   meginfo : <required> <<struct>> MEGinfo
%     event : <optional> <<string>> event name with which condition transfer
%           :  ['LOAD_DATA']
%  loadspec : <optional> <<struct>> specification to load the fields of which
%           :  are mainly as follows:
%           :   
% [output]
%   next_acqtype : next value of acq_type field
% [note]
%   support for only YOKOGAWA
% [history]
%   2008-02-21 (Sako) initial version
%   2009-07-28 (Sako) added loadspec
%   2011-05-30 (Sako) modified to convert device character to be upper case
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
if ~exist('event', 'var'), event = ''; end
if ~exist('loadspec', 'var'), loadspec = []; end
[meginfo, event, loadspec] = inner_check_arguments(meginfo, event, loadspec);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;

vb_define_device;

device = vb_meginfo_get_device(meginfo);
Device = upper(device);
cur_acqtype = vb_meginfo_get_acqtype(meginfo);

if strcmp(Device, 'YOKOGAWA')
  
  switch event
    case 'LOAD_DATA'
      switch cur_acqtype
        case MEG_ACQTYPE_CON_RAW
          if ~isempty(loadspec) ...
            && isfield(loadspec, 'Trigger') ...
            && length(loadspec.Trigger) > 1
            next_acqtype = MEG_ACQTYPE_EVO_RAW;
          else
            next_acqtype = cur_acqtype;
          end

        case MEG_ACQTYPE_EVO_RAW
          next_acqtype = MEG_ACQTYPE_EVO_RAW;

        case MEG_ACQTYPE_EVO_AVE
          next_acqtype = MEG_ACQTYPE_EVO_AVE;

        otherwise
          warning('(%s)unknown acq_type : %s - not be changed\n', ...
            func_, cur_acqtype);
          next_acqtype = cur_acqtype;
      end

    otherwise
      warning('(%s)unknown event : %s - not be changed\n', ...
        func_, cur_acqtype);
      next_acqtype = cur_acqtype;
  end

else
  warning('(%s)Device (%s) is officially not be supported\n', func_, Device);
  next_acqtype = cur_acqtype;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, event, loadspec] = ...
  inner_check_arguments(meginfo, event, loadspec)
func_ = mfilename;
if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if isempty(event)
  event = 'LOAD_DATA';
end

if isempty(loadspec)
  % require no action
end
return
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %


% --- END OF FILE --- %
