function [ch_name] = vb_meginfo_get_extra_channel_name(meginfo, ex_type)
% return name of extra channel
% [usage]
%   [ch_name] = vb_meginfo_get_extra_channel_name(meginfo, ex_type)
% [input]
%   meginfo : <required> <<struct>> MEG information which must have EEGinfo
%   ex_type : <required> extra type as follows
%           :  0) all_ch_name
%           :  1) eeg_ch_name
%           :  2) null_ch_name
%           :  3) ecg_ch_name
%           :  4) refmg_ch_name
%           : 10) all_ch_name
% [output]
%   ch_name : appropriate channel name
% [note]
%   In the new specification, refference magnetometer channel is set apart
%   from extra channels
%   So, ex_type was redefined as follows.
%     0) all extra channels except refmg_ch  (as new)
%    10) all extra channels include refmg_ch (as old)
% [history]
%   2007-06-27 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var') meginfo = []; end
if ~exist('ex_type', 'var') ex_type = []; end
[meginfo, ex_type] = inner_check_arguments(meginfo, ex_type);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = 'vb_meginfo_get_extra_channel_name';

switch ex_type
  case  0, ch_name = 'all_ch_name';
  case  1, ch_name = 'eeg_ch_name';
  case  2, ch_name = 'null_ch_name';
  case  3, ch_name = 'ecg_ch_name';
  case  4, ch_name = 'refmg_ch_name';
  case 10, ch_name = 'all_ch_name';
  otherwise
    error('(%s)unexpected ex_type : %d', func_, ex_type);
end

if ~isfield(meginfo.EEGinfo, ch_name)
  error('(%s)MEGinfo.EEGinfo must have ''%s''', func_, ch_name');
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, ex_type] = inner_check_arguments(meginfo, ex_type)

func_ = 'vb_meginfo_get_extra_channel_name';

if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if ~isfield(meginfo, 'EEGinfo')
  error('(%s)MEGinfo must have EEGinfo field', func_);
end

if isempty(ex_type)
  error('(%s)ex_type is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
