function [device] = vb_meginfo_get_device(meg_info)
% return device from MEGinfo
% [usage]
%   [device] = vb_meginfo_get_device(meg_info)
% [input]
%   meg_info : <required> <<struct>> MEGinfo which must have 'device' field
% [output]
%     device : <<string>> device name
% [note]
%
% [history]
%   2008-02-08 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
[meg_info] = inner_check_arguments(meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if ~isfield(meg_info, 'device')
  device = '';
else
  device = meg_info.device;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info] = inner_check_arguments(meg_info)
func_ = mfilename;
if isempty(meg_info)
  error('(%s)meg_info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %



%%% END OF FILE %%%
