function Nchannel = vb_meginfo_get_channel_number_refmg(meginfo, active_swt)
% get number of refference magnetometer channel from MEGinfo struct
% [usage]
%   Nchannel = vb_meginfo_get_channel_number_refmg(meginfo, active_swt)
% [input]
%      meginfo : <required> <<struct>> MEG information
%   active_swt : <optional> <<boolean>> [false] switch for active filter
%              :   true) only active channels
%              :  false) all the channels
% [output]
%     Nchannel : number of refference magnetometer channel
% [note]
%   @see MEGinfo.ExtraChannelInfo
%   @see vb_meginfo_get_channel_label_refmg
% [history]
%   2007-06-27 (Sako) initial version
%   2008-02-01 (Sako) modified for new spec
%   2008-05-01 (Sako) added active_swt
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[meginfo, active_swt] = inner_check_arguments(meginfo, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
refmg_ch_name = vb_meginfo_get_channel_label_refmg(meginfo, active_swt);
Nchannel = size(refmg_ch_name,1);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, active_swt] = inner_check_arguments(meginfo, active_swt)
func_ = mfilename;
if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if ~isfield(meginfo, 'ExtraChannelInfo')
  error('(%s)meginfo must have ExtraChannelInfo field', func_);
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()

%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
