function Nchannel = vb_meginfo_get_channel_number_meg(meginfo, active_swt)
% get number of meg channel from MEGinfo struct and return it
% [usage]
%   Nchannel = vb_meginfo_get_channel_number_meg(meginfo, active_swt)
% [input]
%    meginfo : <required> <<struct>> MEG information
%   active_swt : <optional> <<boolean>> return switch [false]
%              :   true) return number of only active channels
%              :  false) return number of all the channels
% [output]
%   Nchannel : number of meg channel
% [note]
%   
% [history]
%   2007-06-19 (Sako) initial version
%   2008-02-08 (Sako) modified according to new spec
%   2008-04-15 (Sako) added active_swt
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[meginfo, active_swt] = inner_check_arguments(meginfo, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%

if ~vb_info_active_channel_is_valid(meginfo)
  Nchannel = length(meginfo.MEGch_name);
  return;
end

if ~active_swt
  Nchannel = length(meginfo.MEGch_name);
  return;
end

active_list = vb_info_get_active_channel(meginfo);
Nchannel = length(find(active_list==1));
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, active_swt] = inner_check_arguments(meginfo, active_swt)
func_ = mfilename;

if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if ~isfield(meginfo, 'MEGch_name');
  meginfo.MEGch_name = [];
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()

%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
