function [label_list] = vb_meginfo_get_channel_label_meg(meginfo, active_swt)
% get channel label list from MEGinfo and return it
% [usage]
%   [label_list] = vb_meginfo_get_channel_label_meg(meginfo, active_swt)
% [input]
%      meginfo : <required> <<struct>> MEG information
%   active_swt : <optional> <<boolean>> [false]
%              :   true) return only active channel (MEG)
%              :  false) return all the channel (MEG)
% [output]
%   label_list : channel label list
% [note]
%   .MEGch_name field keeps meg channel name not extra nor reference
% [history]
%   2007-05-25 (Sako) initial version
%   2008-04-14 (Sako) added active_swt
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[meginfo, active_swt] = inner_check_arguments(meginfo, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
label_list = meginfo.MEGch_name;
if isempty(label_list)
  return;
end

if ~active_swt
  return;
end

active_list = vb_info_get_active_channel(meginfo);
if length(active_list) ~= length(label_list)
  fprintf('(%s) different length - active list and label list\n', mfilename);
  return;
end
label_list = label_list(active_list == 1);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, active_swt] = inner_check_arguments(meginfo, active_swt)
func_ = mfilename;
if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if ~isfield(meginfo, 'MEGch_name')
  error('(%s)MEGch_name is a required field of MEGinfo', func_);  
end

if ~vb_info_active_channel_is_valid(meginfo)
  active_swt = false;
elseif isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
