function [acqtype] = vb_meginfo_get_acqtype(meginfo)
% <<getter>> for for acquisition type fo MEGinfo
% [usage]
%   [acqtype] = vb_meginfo_get_acqtype(meginfo)
% [input]
%   meginfo : <required> <<struct>> MEGinfo
% [output]
%   acqtype : value of acquisition type
%           :  e.g.
%           :   'Continuous_Raw'
%           :   'Evoked_Ave'
%           :   'Evoked_Raw'
% [note]
%   The new standard format was defined. (2011-05)
% [history]
%   2008-02-21 (Sako) initial version
%   2011-05-26 (Sako) modified according to the new data format
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
[meginfo] = inner_check_arguments(meginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
acqtype = [];

if isfield(meginfo, 'device_info')
  if isfield(meginfo.device_info, 'acq_type')
    acqtype = meginfo.device_info.acq_type;
  else
%     warning('device_info does not have ''acq_type'' field\n');
  end
else
  if isfield(meginfo, 'acq_type')
    acqtype = meginfo.acq_type;
  else
%     warning('meginfo does not have ''acq_type'' field\n');
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo] = inner_check_arguments(meginfo)
func_ = mfilename;

if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
