function [acq_file] = vb_meginfo_get_acqfile(meg_info)
% MEGinfo getter for acquisition file path
% [usage]
%   [acqfile] = vb_meginfo_get_acqfile(meg_info)
% [input]
%   meg_info : <required> <<struct>> MEG information
% [output]
%   acq_file : value of acquisition file path field
% [note]
%   if the given MEGinfo does not have an appropriate field, return empty
%   The new standard format was defined. (2011-05)
% [history]
%   2007-06-12 (Sako) initial version
%   2011-05-26 (Sako) changed according to the new data format
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
[meg_info] = inner_check_arguments(meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% --- compatible with old style
acq_file = '';

if isfield(meg_info, 'device_info')
  if isfield(meg_info.device_info, 'acq_info')

    if isfield(meg_info.device_info.acq_info, 'data_file')
      acq_file = meg_info.device_info.acq_info.data_file;
    else
%       warning('--- device_info.acq_info does not have ''acq_file'' field\n');
    end

  else
%     warning('--- device_info does not have ''acq_info'' field\n');
  end

else
  if isfield(meg_info, 'acq_info')
    if isfield(meg_info.acq_info, 'data_file')
      acq_file = meg_info.acq_info.data_file;
    else
%       warning('--- acq_info does not have ''data_file'' field\n');
    end
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info] = inner_check_arguments(meg_info)
func_ = mfilename;
if isempty(meg_info)
  error('(%s)meg_info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
