function vb_megfile_patch_posfile(megfile, posfile, outfile)
% update coordinates which have not been transformed
% [usage]
%   vb_megfile_patch_posfile(megfile, posfile, outfile)
% [input]
%   megfile : <required> MEG-MAT file
%           :   the coordinates of which are not tranformed
%   posfile : <required> POS-MAT file
%   outfile : <optional> output file ['megfile']
% [output]
%   none
% [note]
%
% [see also]
%   vb_load_sensor
%
% [history]
%   2009-04-16 (Sako) initial version
%   2011-08-31 (Sako) modified how to call vb_load_sensor
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('megfile', 'var'), megfile = ''; end
if ~exist('posfile', 'var'), posfile = ''; end
if ~exist('outfile', 'var'), outfile = ''; end
[megfile, posfile, outfile] = inner_check_arguments(megfile, posfile, outfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;

meginfo = vb_megfile_load_meginfo(megfile);
if isempty(meginfo)
  error('(%s) meginfo is empty', func_);
end

meg = load(megfile);
transinfo = vb_info_get_transinfo(meginfo);

if isempty(transinfo)
  [old_pick, old_Qpick] = vb_load_sensor(megfile, 'MEG', '', false);

  [pick, Qpick] = vb_meg_transform_coordinate(old_pick, old_Qpick, '', posfile);
  [MEGinfo] = vb_info_add_posfile_info(meginfo, posfile);

  meg.pick = pick;
  meg.Qpick = Qpick;
  meg.MEGinfo = MEGinfo;
else
  fprintf('(%s) do nothing because there is MEGinfo.TransInfo\n', func_);
  return;
end

if isempty(outfile)
  outfile = megfile;
end

save_cmd = sprintf('save %s -struct meg', outfile);
eval(save_cmd);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [megfile, posfile, outfile] = ...
  inner_check_arguments(megfile, posfile, outfile)
func_ = mfilename;
if ~inner_is_valid_input_file(megfile)
  error('(%s) megfile is invalid', func_);
end
if ~inner_is_valid_input_file(posfile)
  error('(%s) megfile is invalid', func_);
end

if isempty(outfile)
  % nothing to do
end
return;
%
% --- end of inner_check_arguments()

% --- inner_is_valid_input_file()
%
function result = inner_is_valid_input_file(cur_file)
% result : <<boolean>>
if isempty(cur_file)
  result = false;
  return;
end

if exist(cur_file, 'file') ~= 2
  result = false;
  return;
end

result = true;
return;
%
% --- end of inner_is_valid_input_file()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
