function MEGinfo = vb_megfile_load_meginfo(megfile)
% load MEGinfo struct from megfile and return it
% [usage]
%   meginfo = vb_megfile_load_meginfo(megfile)
% [input]
%    megfile : <required> <<file>> MEG-MAT file
% [output]
%   MEGinfo : <<struct>> MEG information
% [note]
%   
% [history]
%   2007-05-25 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('megfile', 'var'), megfile = []; end
[megfile] = inner_check_arguments(megfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
MEGinfo = [];
load(megfile, 'MEGinfo');
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [megfile] = inner_check_arguments(megfile)
func_ = mfilename;
if isempty(megfile)
  error('(%s)megfile is a required parameter', func_);
end

if exist(megfile, 'file') ~= 2
  error('(%s)cannot find megfile : %s', func_, megfile);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %
  
% --- END OF FILE --- %
