function [coordtype] = vb_megfile_load_coordtype(megfile)
% read coordinate type from MEG-MAT file
% [usage]
%   [coordtype] = vb_megfile_load_coordtype(megfile)
% [input]
%   megfile : <required> <<file>> MEG-MAT file
% [output]
%   coordtype : <<string>> coordinate type e.g. 'SPM_Right_M'
%             :  If MEG-MAT file does not have any appropriate field, 
%             :  return empty.
%             :  If MEG-MAT file is invalid, return 'BAD_MEG_FILE' for now
% [note]
%
% [history]
%   2008-04-01 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('megfile', 'var'), megfile = ''; end
[megfile] = inner_check_arguments(megfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isempty(megfile)
  coordtype = 'BAD_MEG_FILE';
  return;
end

load(megfile, 'CoordType');
if exist('CoordType', 'var')
  coordtype = CoordType;
else
  fprintf('(%s)MEG-MAT file (%s) does not have coordinate type field\n', ...
    mfilename, megfile);
  coordtype = '';
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [megfile] = inner_check_arguments(megfile)
func_ = mfilename;
if isempty(megfile)
  fprintf('(%s)megfile is invalid\n', func_);
  return;
end

if exist(megfile, 'file') ~= 2
  fprintf('(%s)cannot find megfile : %s\n', func_, megfile);
  megfile = '';
  return;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
