function [freq] = vb_megfile_get_sampling_frequency(megfile)
% return valid sampling frequency from MEG-MAT file
% [usage]
%   [channel_list] = vb_megfile_get_sampling_frequency(megfile)
% [input]
%   megfile : <required> <<file>> MEG-MAT file (*.meg.mat)
% [output]
%      freq : value of sampling frequency
% [note]
%   @see vb_meginfo_get_sampling_frequency.m
% [history]
%   2007-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('megfile', 'var') megfile = []; end
[megfile] = inner_check_arguments(megfile);


% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meginfo = vb_megfile_load_meginfo(megfile);
freq = vb_meginfo_get_sampling_frequency(meginfo);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [megfile] = inner_check_arguments(megfile)
func_ = mfilename;
if isempty(megfile)
  error('(%s)megfile is a required parameter', func_);
end

if exist(megfile, 'file') ~= 2
  error('(%s)cannot find megfile : %s', func_, megfile);
end
return;
%
% --- end of inner_check_arguments()

% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
