function [Measurement] = vb_megfile_get_measurement(megfile)
% return Measurement parameter from megfile
% [usage]
%   [measurement] = vb_megfile_get_measurement(megfile)
% [input]
%   megfile : <required> <<file>> MEG-MAT file
% [output]
%   Measurement : Measurement string which is saved in MEG-MAT file
% [note]
%
% [history]
%   2007-07-12 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('megfile', 'var') megfile = []; end
[megfile] = inner_check_arguments(megfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
Measurement = [];
load(megfile, 'Measurement');
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [megfile] = inner_check_arguments(megfile)
func_ = mfilename;

if isempty(megfile)
  error('(%s)megfile is a required parameter', func_);
end

if exist(megfile, 'file') ~= 2
  error('(%s)cannot find MEG-MAT file : %s', func_, megfile);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
