function [new_pick, new_Qpick, new_type] = ...
  vb_meg_transform_coordinate(org_pick, org_Qpick, org_type, posfile)
% transform coordinate system of sensor
% [usage]
%   [new_pick, new_Qpick, new_type] = ...
%      meg_change_coordinate(org_pick, org_Qpick, org_type, posfile)
% [input]
%    org_pick : <required> [Nchannel x 3] sensor coordinate
%   org_Qpick : <optional> [Nchannel x 3] sensor vector []
%    org_type : <optional> <<string>> coordinate type of org_pick
%     posfile : <optional> <<file>> POS-MAT file ['']
%             : if this is empty, org_pick and org_Qpick are not transformed.
% [output]
%    new_pick : transformed sensor coordinate [Nchannel x 3]
%   new_Qpick : transformed sensor vector [Nchannel x 3]
%    new_type : new coordinate type e.g. 'SPM_Right_m'
% [note]
%
% [history]
%   2008-03-13 (Sako) initial version
%   2009-04-15 (Sako) modified serious bug of calling vb_affine_trans for Qpick
%   2009-08-10 (Sako) added to check coord types between current and trans_after
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('org_pick', 'var'), org_pick = []; end
if ~exist('org_Qpick', 'var'), org_Qpick = []; end
if ~exist('org_type', 'var'), org_type = ''; end
if ~exist('posfile', 'var'), posfile = []; end
[org_pick, org_Qpick, trans_mri, new_type] = ...
  inner_check_arguments(org_pick, org_Qpick, org_type, posfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isempty(trans_mri)
  % does not translate
  new_pick = org_pick;
  new_Qpick = org_Qpick;
  return;
end

new_pick  = vb_affine_trans(org_pick, trans_mri);

if ~isempty(org_Qpick)
  % only rotate
  new_Qpick = vb_affine_trans(org_Qpick, trans_mri, 1);
else
  new_Qpick = [];
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [pick, Qpick, trans_mri, new_type] = ...
  inner_check_arguments(pick, Qpick, old_type, posfile)
func_ = mfilename;

trans_mri = [];
% new_coord_type = type;

if isempty(pick)
  error('(%s)org_pick is a required parameter', func_);
end

if isempty(Qpick)
  % require no action for now
end

if isempty(posfile)
  trans_mri = [];
  new_type = old_type;
  
elseif exist(posfile, 'file') ~= 2
  error('(%s)cannot find posfile : %s', func_, posfile);

else

  [trans_mri, type_bef, type_aft] = vb_posfile_get_transinfo(posfile);
  if strcmp(old_type, type_aft)
    trans_mri = [];
    new_type = old_type;
  else
    new_type = type_aft;
  end
end
return
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
