function [ch_info] = vb_ch_info_set_channel_info_ext(ch_info, ch_list)
% <<provate>> set EXTRA channel label list to ch_info
% [usage]
%   [ch_info] = vb_ch_info_set_channel_info_ext(ch_info, ch_list)
% [input]
%   ch_info : <required> <<struct>> temporal channel information 
%           :   which is before changing
%   ch_list : <optional> list of EXTRA channel label [N x 1] or [1 x N]
% [output]
%   ch_info : <<struct>> temporal channel information which is after changing
% [note]
%   this function is private
%   returned channel list's size is [N x 1]
% [history]
%   2007-07-12 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('ch_info', 'var'), ch_info = []; end
if ~exist('ch_list', 'var'), ch_list = []; end
[ch_info, ch_list] = inner_check_arguments(ch_info, ch_list);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
ch_info.ext_channel = ch_list;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [ch_info, ch_list] = inner_check_arguments(ch_info, ch_list)
func_ = mfilename;
if isempty(ch_info)
  error('(%s)ch_info is a required parameter', func_);
end

if isempty(ch_list)
  % require no action
else
  % [N x 1]
  ch_list = vb_util_arrange_list(ch_list);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
