function vb_megfile_remove_offset(megfile,megfile_new,baseline)
% Remove offset of signal by subtracting the mean signal amplitude
%
% --- Syntax
% vb_megfile_remove_offset(megfile,megfile_new,baseline)
%
% --- Input (optional)
% baseline: Time index of baseline period. If not specified, pretrigger
% is used.
%
% --- Example
% >> megfile1='meg1.meg.mat';
% >> megfile2='meg2.meg.mat';
% >> baseline=[101 500];
%
% --- History
% 2008-05-08 Taku Yoshioka
% 2008-06-16 Taku Yoshioka
% 2008-06-27 Taku Yoshioka (baseline)
% 2010-01-26 (Sako) renamed
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

const = vb_define_const;

if nargin<1, help vb_megfile_remove_offset; end

MEGinfo = vb_load_meg_info(megfile);

% Baseline
if nargin<3 || isempty(baseline), 
  Tbase = 1:MEGinfo.Pretrigger;
else
  Tbase = baseline(1):baseline(2);
end

% Remove offset
for i=1:MEGinfo.Nrepeat
  load_spec.TrialNumber = i;
  load_spec.ActiveChannel = false;
  
  load_spec.ChannelType = const.DATA_TYPE_MAIN;
  meg_data = vb_load_meg_data(megfile,load_spec);
  
  load_spec.ChannelType = const.DATA_TYPE_EXTRA;
  ext_data = vb_load_meg_data(megfile,load_spec);
  
  load_spec.ChannelType = const.DATA_TYPE_REFERENCE;
  ref_data = vb_load_meg_data(megfile,load_spec);
  
  offset = mean(meg_data(:,Tbase),2);
  meg_data = meg_data-repmat(offset,[1 size(meg_data,2)]);
  new_data.bexp(:,:,i) = meg_data;
  new_data.bexp_ext(:,:,i) = ext_data;
  new_data.refmg(:,:,i) = ref_data;
end

vb_msrmnt_store_data(megfile,new_data,[],megfile_new);

