function vb_megfile_remove_noisysensor(megfile,megfile_new)
% Remove sensors that is possibly broken. 
%
% --- Syntax
% vb_megfile_remove_noisysensor(megfile,megfile_new)
%
% --- History
% 2008-05-09 Taku Yoshioka
% 2008-06-18 Taku Yoshioka
% 2010-01-19 (Sako) replaced log_meg_info with log_measurement_info
% 2010-01-22 (Matt) made more efficient
% 2010-01-26 (Sako) renamed
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

const = vb_define_const;

% Default parameters
threshold = 9;   % ratio to the median of signals
NnoisyTrial = 5; % If the number of noisy trial exceeds this value, the 
                 % sensor is removed. 
verbose = 2;     % verbose level
if nargin<1, help vb_megfile_remove_noisysensor; end

% Get information of MEG data
MEGinfo = vb_load_measurement_info(megfile);
ActTrial = vb_info_get_active_trial(MEGinfo);
ActChannel = vb_info_get_active_channel(MEGinfo);
ChannelName = vb_info_get_channel_label(MEGinfo);

ch_info = vb_load_channel_info(megfile,'PLANAR');
ActChannel(ch_info.ID)=0;

load_spec.ChannelType = const.DATA_TYPE_MAIN;
full_meg_data = vb_load_meg_data(megfile,load_spec);  

% Create histogram
for i=1:MEGinfo.Nrepeat
  if ~ActTrial(i), continue; end
  load_spec.TrialNumber = i;
  load_spec.ActiveChannel = true;
  
  meg_data = full_meg_data(ActChannel==1,:,i);
  
  if i==1, 
    m_max = max(abs(meg_data(:)));
    dx = m_max/100;
    x = dx:dx:m_max;
    y = hist(abs(meg_data(:)),x);
  else
    y = y+hist(abs(meg_data(:)),x);
  end
end

% Calculate threshold value
Ndata = sum(y(:));
Nmed = 0;
x = x*1e15;
for i=1:length(y)
  Nmed = Nmed+y(i);
  if Nmed>=Ndata/2, 
    th = threshold*x(i);
    break;
  end
end

% Plot histogram
bar(x,y)
yrange = ylim;
line([th th],[yrange(1) yrange(2)],'LineStyle','--','Color','k');
title('Histogram of signal amplitude');
xlabel('MEG signal [fT]');

% Show dialog to set threshold value
answer = inputdlg('Input threshold value','Threshold for noisy signal', ...
                  1,{num2str(th,'%.1f')});
close;
if isempty(answer), return; end
if ~isempty(answer{1}), th = str2num(answer{1}); end

% Find noisy sensors
ix_channel = [];
clear load_spec;
for i=1:MEGinfo.Nchannel
  if ~ActChannel(i), continue; end
  load_spec.ChannelName{1} = ChannelName{i};
  load_spec.ChannelSwitch = true;
  load_spec.ActiveTrial = true;  
  
  meg_data = full_meg_data(i,:,:);
  meg_data = meg_data*1e15;
  
  ix_trial = [];
  max_signal = [];
  for j=1:size(meg_data,3)
    tmp = abs(meg_data(:,:,j));
    if max(tmp)>th, 
      ix_trial = [ix_trial; j]; 
      max_signal = [max_signal; max(tmp)];
    end
  end
  
  [tmp,ix] = sort(-1*max_signal);
  ix_trial = ix_trial(ix);
  
  if length(ix_trial)>NnoisyTrial, 
    if verbose==2,
      N = min([5 length(ix_trial)]);
      for j=1:N
        subplot(N,1,j);
        plot(meg_data(:,:,ix_trial(j)));
      end
      title('Signal time courses');
      ylabel('[fT]');
      remove_sensor = questdlg(['Remove sensor ' ChannelName{i} '?'], ...
                               'Remove sensor','Yes','No','Yes');
      close;
    else
      remove_sensor = 'Yes';
    end
    
    if strcmp(remove_sensor,'Yes'), ActChannel(i) = false; end
  end
end

% Update MEGinfo struct
update_spec.preprocess_parm.parm = [];
update_spec.active_channel = ActChannel;
vb_msrmnt_make_preprocessed_file(megfile,update_spec,megfile_new);
