function	y = vb_online_lowpass_filt(x,Fs,Flow)
% Highpass cut filter using Online lowpass filter
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[Nch,T] = size(x);

% Initialize lowpass filter
[a, z] = vb_lowpass_init(Fs,Flow,Nch);

% Online lowpass filtering 
y = zeros(Nch,T);

for t=1:T
	z = vb_online_lowpass(a,x(:, t),z);
	y(:,t) = z;
end
