function	[z] = vb_online_lowpass(a,x,z)
% Online calculation of 1st order lowpass filter
%   [z] = vb_online_lowpass(a,x,z)
% --- Input
% a  : Coefficient of lowpass filter              [D x Nbank]
% x  : Input signal                               [D x 1] or [D x Nbank]
% z  : Lowpass signal (State variable for online-filter)  [D x Nbank]
% --- Output
% z  : Lowpass signal (Updated value)                     [D x Nbank]
%
% 2007-9-21 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Mx = size(x,2);
Mz = size(z,2);

if Mx == 1,
	z = a .* z + x * (1 - a(1,:));
elseif Mx==Mz
	z = a .* z + x .* (1 - a);
end
