function	[Y, Z] = vb_online_filter_loop(A, B, C, D, X, Z)
% Online filter calculation
% [Y, Z] = vb_online_filter_loop(A, B, C, D, X, Z)
%   [A, B, C, D] : filter matrix
%	A: D x D, 
%	B: 1 x D, 
%	C: D x 1, 
%	D: 1 x 1
% X : Input signal (Nch x T)
% Z : Internal state variable (Nch x D)
% Y : Output signal  (Nch x T)
%
%	[A, B, C, D] = butter(Norder, freq/(fsamp/2));
%	A = A'; B = B'; C = C'; D = D';
%   D = Norder or 2*Norder
%	A: D x D, 
%	B: 1 x D, 
%	C: D x 1, 
%	D: 1 x 1
%
%	Y = Z * C + X * D; % Output update
%	Z = Z * A + X * B; % Internal state variable update
%
% Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[Nch, T] = size(X);

Y = zeros(Nch, T);

for t=1:T
	Y(:,t) = Z * C + X(:,t) * D;
	Z      = Z * A + X(:,t) * B;
end
