function w = vb_multiple_regression(x, y)
% Multiple linear regression
%
% - Input
%   x: Independent variable (dimension x sample)
%   y: Dependent variable (1 x sample)
%
% - Output
%   w: Coefficients (1 x dimension) (end of w is bias)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

xt = [x', ones(size(x,2),1)];
xx = xt'*xt;
xy = xt'*y';
w = (xx\xy)';

