function	[spx ,freq ] = vb_calc_spectrum(xdata,fs,window_type)
% Calculate spectrum
%  [spx ,freq ] = vb_calc_spectrum(xdata,fs,window_type)
% --- Input
%  xdata  : signal to analyze (Xdim x TimeSample)
%  fs     : Sampling frequency (Hz)
%  window_type : name of window function
%         = 'hanning'	(Default)
%         = 'hamming'
%         = 'blackman'
% --- Output
% spx  : Fourier spectrum of 'xdata'
% freq : frequency value for spx
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('window_type','var') | isempty(window_type), 
	window_type = 'hanning'; 
end;

if ~exist('fs','var') | isempty(fs), fs = 1000; end;

[xdim,T] = size(xdata);

com = ['win=' window_type '(T);'];
eval(com);

xx  = vb_repmultiply(xdata' ,win);

nfft = nextpow2(T);
nfft = 2^nfft;

spx = abs(fft(xx,nfft))';
spx = spx(:,1:nfft/2+1);

d=fs/nfft;
freq=0:d:d*(nfft/2);

return

%spx = zeros(xdim,T);
%
%for n = 1:xdim
%	spx(n,:) = abs(fft(xdata(n,:).*win));
%end
