function [pretrigger] = vb_eeginfo_get_pre_trigger(EEGinfo)
% return pre-trigger from current EEGinfo struct
% [usage]
%   [pretrigger] = vb_eeginfo_get_pre_trigger(EEGinfo)
% [input]
%      EEGinfo : <required> <<struct>> EEG information
% [output]
%   pretrigger : pre-trigger value of current EEGinfo
% [note]
%   if given EEGinfo does not have the appropriate field, return empty [].
% [hisotory]
%   2007-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('EEGinfo', 'var'), EEGinfo = []; end
[EEGinfo] = inner_check_arguments(EEGinfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
pretrigger = EEGinfo.Pretrigger;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [EEGinfo] = inner_check_arguments(EEGinfo)

func_ = mfilename;
if isempty(EEGinfo)
  error('(%s)EEGinfo is a required parameter', func_);
end

if ~isfield(EEGinfo, 'Pretrigger')
  EEGinfo.Pretrigger = [];
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
