function [Nchannel] = vb_eeginfo_get_channel_number(eeginfo, active_swt)
% return channel number from EEGinfo struct
%
% [usage]
%   [Nchannel] = vb_eeginfo_get_channel_number(eeginfo, active_swt)
%
% [input]
%      eeginfo : <required> <<struct>> EEG header information
%   active_swt : <optional> <<boolean>> [false]
%              :  switch to return whether all the channels or only active
%              :   true) only active channels
%              :  false) all the channels
%
% [output]
%     Nchannel : number of channel
%
% [note]
%    target channel is sensor channels except for external channels
%
% [history]
%   2007-08-02 (Sako) initial version
%   2008-04-15 (Sako) added active_swt
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
if ~exist('active_swt', 'var'), active_swt = []; end 
[eeginfo, active_swt] = inner_check_arguments(eeginfo, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if ~vb_info_active_channel_is_valid(eeginfo)
  ChannelLabel = vb_eeginfo_get_channel_label(eeginfo);
  Nchannel = length(ChannelLabel);
  return;
end

if ~active_swt
  ChannelLabel = vb_eeginfo_get_channel_label(eeginfo);
  Nchannel = length(ChannelLabel);
  return;
end

active_list = vb_info_get_active_channel(eeginfo);
Nchannel = length(find(active_list==1));
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo, active_swt] = inner_check_arguments(eeginfo, active_swt)
func_ = mfilename;

if isempty(eeginfo)
  error('(%s)eeginfo is a required parameter', func_);
end

if isempty(active_swt)
  % return all the channel
  active_swt = false;
end

if ~isfield(eeginfo, 'Nchannel')
  eeginfo.Nchannel = 0;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
