function [ch_list, bit_list] = ...
  vb_eeg_get_active_trigger_channel(status_data, bit_len)
% extract active trigger channels by reading status channel data
% [usage]
%   [ch_list, bit_list] = vb_eeg_get_active_trigger_channel(status_data, bit_len)
% [input]
%   status_data : <required> data of status channel [1 x N]
%       bit_len : <optional> bit length of data [24]
% [output]
%    ch_list : list of active trigger channels
%   bit_list : list of bit of selected channel
% [note]
% [history]
%   2007-01-04 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('status_data', 'var'), status_data = []; end;
if ~exist('bit_len', 'var'), bit_len = []; end;
[status_data, bit_len] = inner_check_arguments(status_data, bit_len);


% --- MAIN PROCEDURE --------------------------------------------------------- %
%
ch_list = [];

data_len = size(status_data,2);
BIT_LEN = bit_len;

result_box = zeros(1,data_len);
all_bit_list = zeros(1,data_len);
bit_list = zeros(1,data_len);

% VERBOSE = 0;
VERBOSE = 1;
if VERBOSE, fprintf('  >>> read status bit (%d) ', BIT_LEN); end;

list_cnt = 0;

for nbit = 1:BIT_LEN
  check_bit = 2 ^ (nbit-1);
  result_box = vb_bitand_ex(status_data(:,:),check_bit,BIT_LEN);
  all_bit_list = (result_box == check_bit);

  % if all bit is high, it means not to be connected (maybe)
  if any(all_bit_list) && ~all(all_bit_list)
    ch_list = [ch_list, nbit];
    bit_list(size(ch_list,2),:) = all_bit_list;
  end
  if VERBOSE, fprintf('.'); end;
end
if VERBOSE, fprintf(' done\n'); end;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [status_data, bit_len] = inner_check_arguments(status_data, bit_len)
if isempty(status_data)
  error('status_data is a required parameter');
end

if isempty(bit_len), bit_len = 24; end;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
