function vb_mark_trigger( ...
  msrmnt_file, target_list, to_read_swt, output_file, auto_info)
% receive a demand to mark trigger
%
% [usage]
%   vb_mark_trigger( ...
%     msrmnt_file, target_list, to_read_swt, output_file, auto_info)
%
% [input]
%   msrmnt_file : <required>
%        : MAT file which includes next information :
%        :   - data (Nchannel x Nsample) <must>
%        :   - base channel list <must>
%        :   - sample_frequency <if needed>
%        : e.g. EEG-MAT (.eeg.mat), MEG-MAT (.meg.mat)
%   target_list : <optional> [[]]
%        : list of used channel label
%        :   "base channel list" must have these channels
%   to_read_swt : <optional> [false]
%        : switch that "target_list" is whether to read or not
%        :   true or false
%        :   error if "to_read_swt" is true and "target_channel_list" is empty
%   output_file : <optional> ['./trigger_list.mat']
%     auto_info : <optional> <<struct>> [[]]
%        : information for auto marking
%        : - auto_detect     : get trigger label by auto-detect
%        :                   : true or false [false]
%        :                   : (highest priority)
%        : - trigger_channel : trigger channel label of "base channel list"
%        : - trigger_file    : MAT file which includes trigger information
%        : - how             : how to get triggers
%        :                   : 'FULL' or 'SEMI' or 'FILE' or 'MANUAL'
%        :                   : this field shoud be set in this function
%
% [output]
%   none
%
% [note]
%   See alse
%     vb_do_mark_trigger
%
% [history]
%   2007-01-10 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

vb_define_device;

% --- CHECK ARGUMENTS --- %
if ~exist('msrmnt_file', 'var'), msrmnt_file = []; end;
if ~exist('target_list', 'var'), target_list = []; end;
if ~exist('to_read_swt', 'var'), to_read_swt = []; end;
if ~exist('output_file', 'var'), output_file = []; end;
if ~exist('auto_info', 'var'), auto_info = []; end;

[msrmnt_file, target_list, to_read_swt, output_file, auto_info] = ...
  inner_check_arguments( ...
    msrmnt_file, target_list, to_read_swt, output_file, auto_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% ===
% switch auto_info.how
%   case  TRIGGER_HOW_FULL
%     [bit_list] = msrmnt_get_valid_trigger_bit_list(msrmnt_file);
%   otherwise
%     % nothing to do here
% end

my_spec = vb_util_make_mark_trigger_spec(msrmnt_file, ...
  target_list, to_read_swt, output_file, auto_info);

vb_do_mark_trigger(my_spec);

% ===
% my_spec = vb_util_make_mark_trigger_spec( ...
%   msrmnt_file, target_list, to_read_swt, output_file, auto_info);
% 
% mark_trigger(my_spec);
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTION --------------------------------------------------------- %
% 
% --- inner_check_arguments()
%
function [msrmnt_file,target_list,to_read_swt,output_file,auto_info] = ...
  inner_check_arguments( ...
    msrmnt_file, target_list, to_read_swt, output_file, auto_info)

vb_define_device;

if isempty(msrmnt_file)
  error('msrmnt_file is a required parameter');
end

% if isempty(target_list) do nothing

if isempty(to_read_swt)
  to_read_swt = false;
end

if isempty(output_file)
  output_file = ['.' filesep 'trigger_list.mat'];
end
if isempty(auto_info)
  auto_info.auto_detect = false;
end
%
% --- end of inner_check_argument()

%%% END OF FILE %%%
