function [data] = vb_load_eeg_ch_data(ch_file)
% load eeg data from channel data file
% [usage]
%   [data] = vb_load_eeg_ch_data(ch_file)
% [input]
%   ch_file : <required> <<file>> cell array of channel data file {1 x N}
% [output]
%      data : loaded data [N x Nsample]
% [note]
%   without processing loaded data
% [history]
%   2007-08-31 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('ch_file', 'var') ch_file = []; end
[ch_file] = inner_check_arguments(ch_file);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;

[data_type,status_ch] = inner_check_status_channel(ch_file)

file_num = size(ch_file, 2);

for file_cnt = 1:file_num
  
  file_path = ch_file{file_cnt};

  if exist(file_path, 'file') ~= 2
    error('(%s)cannot find file : %s', func_, file_path);
  end

  fid = fopen(file_path, 'r');
  if fid < 0
    error('(%s)cannot open : %s', func_, file_path); 
  end

  this_data = fread(fid, data_type{file_cnt});

  if status_ch(file_cnt)
    data(file_cnt,:) = this_data';
  else
    data(file_cnt,:) = this_data;
%     data(file_cnt,:) = this_data * EDF.Cal(idx) + EDF.Off(idx);
  end
  
  fclose(fid);

  % for DEBUG
%   fprintf(' --  read file: ''%s''\n', file_path);
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [ch_file] = inner_check_arguments(ch_file)
func_ = mfilename;

if isempty(ch_file)
  error('(%s)ch_file is required parameter', func_);
end

if ~iscell(ch_file)
  warning('(%s)ch_file must be cell array', func_);
  ch_file = {ch_file};
end
return;
%
% --- end of inner_check_arguments()

% --- inner_check_status_channel()
%
function [data_type, status_ch] = inner_check_status_channel(ch_file)
% data_type is {1 x N}
func_ = mfilename;

vb_define_device;

file_num = size(ch_file,2);
data_type = cell(1, file_num);
status_ch = zeros(file_num, 1);

for file_cnt = 1:file_num
  [fpath,fname,fext] = vb_get_file_parts(ch_file{file_cnt});
  
  if isempty(findstr(fname, STATUS_CH_LABEL))
    data_type{file_cnt} = STANDARD_BIN_DATA_TYPE;
    status_ch(file_cnt) = 0;
  else
    data_type{file_cnt} = STATUS_CH_DATA_TYPE;
    status_ch(file_cnt) = 1;
  end
end

return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %


%%% END OF FILE %%%
