function my_version = vb_latest_version(target_name)
% return the latest version
% [usage]
%   my_version = vb_latest_version(target_name)
% [input]
%   target_name : <required> target name whose version you want to get
% [output]
%    my_version : the latest version
%               :  - if some errors occur, return 0.0 with warning message
% [note]
%   acceptable target_name is as follows
%     'EEGinfo'
% [history]
%   2006-12-05 (Sako) initial version for 'EEGinfo'
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

my_version = 0.0;

if ~exist('target_name', 'var') || isempty(target_name)
  warning('target_name is a required parameter');
  return;
end

switch target_name
  case  'EEGinfo'
    my_version = 0.1;
  otherwise
    warning('unknown target_name : %s', target_name);
    return;
end

%%% END OF FILE %%%
