function [begin_val, end_val] = vb_axisends_get(axisends, type_tag, axis_tag)
% get values of specified both ends 
% [usage]
%   [begin_val, end_val] = vb_axisends_get(axisends, type_tag, axis_tag)
% [input]
%    axisends : <required> <struct>
%             :  fields of this struct are as follows.
%             :   original_x <both_ends>
%             :   slider_x   <both_ends>
%             :   previous_x <both_ends>
%             :   original_y <both_ends>
%             :   slider_y   <both_ends>
%             :   previous_y <both_ends>
%             :
%             :   <struct : both_ends>
%             :      begin
%             :      end
%    type_tag : <required> tag of setting type. case-insensitive
%             :  'ORIGINAL' : original begin and end value
%             :    'SLIDER' : base begin and end value for slider
%             :  'PREVIOUS' : previous begin and end value
%    axis_tag : <required> tag of axis type ('X' or 'Y'). case-insensitive
% [output]
%   begin_val : value of begin
%     end_val : value of end
% [note]
%   vb_axisends_set
% [history]
%   2007-02-19 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('axisends',  'var'),  axisends = []; end;
if ~exist('type_tag',  'var'),  type_tag = []; end;
if ~exist('axis_tag',  'var'),  axis_tag = []; end;
[axisends, type_tag, axis_tag] = ...
  inner_check_arguments(axisends, type_tag, axis_tag);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
begin_val = [];
end_val = [];

switch type_tag
  case  'ORIGINAL'
    switch axis_tag
      case  'X'
        if ~isfield(axisends, 'original_x')
          error('there is not original_x field');
        end;
        begin_val = axisends.original_x.begin;
        end_val   = axisends.original_x.end;
      case  'Y'
        if ~isfield(axisends, 'original_y')
          error('there is not original_y field');
        end;
        begin_val = axisends.original_y.begin;
        end_val   = axisends.original_y.end;
    end
    
  case  'SLIDER'
    switch axis_tag
      case  'X'
        if ~isfield(axisends, 'slider_x')
          error('there is not slider_x field');
        end;
        begin_val = axisends.slider_x.begin;
        end_val   = axisends.slider_x.end;
      case  'Y'
        if ~isfield(axisends, 'slider_y')
          error('there is not slider_y field');
        end;
        begin_val = axisends.slider_y.begin;
        end_val   = axisends.slider_y.end;
    end
    
  case  'PREVIOUS'
    switch axis_tag
      case  'X'
        if ~isfield(axisends, 'previous_x')
          error('there is not previous_x field');
        end;
        begin_val = axisends.previous_x.begin;
        end_val   = axisends.previous_x.end;
      case  'Y'
        if ~isfield(axisends, 'previous_y')
          error('there is not previous_y field');
        end;
        begin_val = axisends.previous_y.begin;
        end_val   = axisends.previous_y.end;
    end
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [axisends, type_tag, axis_tag] = ...
  inner_check_arguments(axisends, type_tag, axis_tag)

if isempty(axisends), error('axisends is a required parameter'); end;
if isempty(type_tag), error('type_tag is a required parameter'); end;
if isempty(axis_tag), error('axis_tag is a required parameter'); end;

type_tag = upper(type_tag);
axis_tag = upper(axis_tag);

if ~strcmp(type_tag, 'ORIGINAL') ...
    && ~strcmp(type_tag, 'SLIDER') ...
    && ~strcmp(type_tag, 'PREVIOUS')
    error('unknown type_tag : %s', type_tag);
end

if ~strcmp(axis_tag, 'X') && ~strcmp(axis_tag, 'Y')
  error('unknown axis_tag : %s', axis_tag);
end
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
