function	vb_select_act_basis(basis_file,new_file,data_file,bias_mode)
% select leadfield for active sensor from leadfield for all channels
%   vb_select_act_basis(basis_file,new_file,data_file)
%   vb_select_act_basis(basis_file,new_file,data_file,bias_mode)
% basis_file : leadfield file name for all channels
% new_file   : output leadfield file name for selected channels
% data_file  : MEG/EEG/INFO file which have active channel info
% bias_mode  : Common refference bias subtraction mode
%            = 0 : No subtraction [default]
%            = 1 : Common refference bias subtraction for leadfield
%
% 2008-10-31 Masa-aki Sato
% 2009-08-21 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('bias_mode','var'), bias_mode = 0; end;

fprintf('Load basis file [%s]\n',basis_file)
load(basis_file,'basis','basis_parm');

fprintf('# of sensor in original basis = %d\n',size(basis,2))

% channel info for data_file (MEG/EEG/INFO)
ch_info = vb_load_channel_info(data_file);

% active channel index
channel_id = ch_info.ID;

% basis( Norient * Nvertex , Nsensor)
% basis( n, k )  : k-th sensor field for dipole current at n
basis = basis(:, channel_id);

if bias_mode == 1,
	fprintf('Common refference bias subtraction\n')
	basis = vb_repadd(basis, - mean(basis,2));
end

fprintf('# of sensor in selected basis = %d\n',size(basis,2))
% Output file path
fprintf('Save basis file [%s]\n',new_file)

basis_parm.channel_id = channel_id;

vb_fsave(new_file,'basis','basis_parm');
