function	vb_plot_channel_trial(ratio1,ratio2, ...
				thred_val1,thred_val2,prob_val,thred_num)
% Plot several statics for 'Threshold' selection
%
% 2022-4-27 k_suzuki
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[Nch, Ntry] = size(ratio1);

% candidate of threshold value
if ~exist('thred_val1','var'), thred_val1 = [8:11]; end;
% max of threshold value
if ~exist('thred_val2','var'), thred_val2 = [8:11]; end; 
% probability for bad trials to select bad channel
if ~exist('prob_val','var'), prob_val = [0.02:0.01:0.05]; end;
if ~exist('thred_num','var'), thred_num = ceil(Nch/4); end;

thred_std = 9; % standard threshold value

Nthre = length(thred_val1);
Nnum  = length(prob_val);

% limit max value for image plot
ratio1 = min(ratio1,max(thred_val1)+1);
ratio2 = min(ratio2,max(thred_val2)+1);

NXfig=Nnum; NYfig=2; 
nfig = 1;
figure;

% # of Bad Channel
Mbad = zeros(Nthre,Nnum);
% # of Bad Trials
Mtry = zeros(Nthre,Nnum);

for n=1:Nthre
	for m=1:Nnum
		thred  = [thred_val1(n), thred_val2(n)];
		% 1. Find noisy trials with multiple bad channels
		ch_act  = [1:Nch];
		try_err = vb_find_bad_trial(ratio1,ratio2,ch_act,thred,thred_num);
		try_act = vb_setdiff2([1:Ntry],try_err);
	
		% 2. Find Bad Channel after removing noisy trials
		ix_ch = vb_find_bad_channel(ratio1(:,try_act),ratio2(:,try_act), ...
									thred,prob_val(m));
		ix_act = vb_setdiff2([1:Nch],ix_ch);
        ix_try = vb_find_bad_trial(ratio1,ratio2, ix_act, thred);
        
		Mch(n,m)  = length(ix_ch);
		Mtry(n,m) = length(ix_try);
	end
end

for m=1:Nnum
	subplot(NYfig,NXfig,nfig); nfig = nfig + 1;
	plot(thred_val1(:),Mch(:,m))
    set(gca,'XTick',thred_val1(:))
    set(gca,'XTickLabel',[num2str(thred_val1(:)) repmat('/',Nthre,1) num2str(thred_val2(:))])
	hold on
	plot([thred_std thred_std], [0 max(Mch(:,m))],'--')
	xlim([thred_val1(1) thred_val1(end)])
	title(sprintf('Bad ch [p=%4.3f]',prob_val(m)))
end
	
for m=1:Nnum
	subplot(NYfig,NXfig,nfig); nfig = nfig + 1;
	plot(thred_val1(:),Mtry(:,m))
    set(gca,'XTick',thred_val1(:))
    set(gca,'XTickLabel',[num2str(thred_val1(:)) repmat('/',Nthre,1) num2str(thred_val2(:))])
	hold on
	plot([thred_std thred_std], [0 max(Mtry(:,m))],'--')
	xlim([thred_val1(1) thred_val1(end)])
	title(sprintf('Bad Trial [p=%4.3f]',prob_val(m)))
end
